import './style.css';
import Cover from '../../components/Cover';
import Navigation from '../../components/Navigation'
import Skills from '../../components/Skills';
import FlipSide from '../../components/FlipSide';
import ContentCircles from '../../components/ContentCircles';
import FullWidthAnimated from '../../components/FullWidthAnimated';
import TimeLine from '../../components/TimeLine';
import TileComponent from '../../components/TileComponent';


function Home () {

    return(
        <div className='home-screen'>
            <Cover/>    
            <Skills/>    
            <FullWidthAnimated/>
            <ContentCircles/>
            <TimeLine/>
            <FlipSide 
                title={'TRAVELLING'}
                imageUrl={'/img/travelling.png'} 
                description={'I love traveling because it allows me to explore new places, experience different cultures, and meet interesting people. Traveling also gives me the opportunity to learn and grow, broadening my perspective on the world.'}
                backgroundColor={'#253e68'}
                color={'white'}
            /> 
            <FlipSide 
                title={'ART'} 
                imageUrl={'/img/trainingcover.jpg'} 
                description={'I have a deep appreciation for art because it enriches my life and stimulates my imagination. Art allows me to connect with different emotions and ideas, and it provides a sense of wonder and beauty. Whether I’m viewing a painting, listening to music, or visiting a museum, art always brings me joy and inspiration.'}
                backgroundColor={'#212429'}
                color={'white'}
                reverse={true} 
            />
            <FlipSide 
                title={'COFFEE'} 
                imageUrl={'/img/coffee.jpg'} 
                description={'I have a deep appreciation for art because it enriches my life and stimulates my imagination. Art allows me to connect with different emotions and ideas, and it provides a sense of wonder and beauty. Whether I’m viewing a painting, listening to music, or visiting a museum, art always brings me joy and inspiration.'}
                backgroundColor={'linear-gradient(0deg, rgba(255,249,218,1) 0%, rgba(182,124,0,1) 35%)'}
                color={'white'}
            /> 
            <TileComponent/>
        </div>
    );

};

export default Home;