import './style.scss';

function TimeLine () {

    const events = [
        {date:'2014 - 2019', headline:'Vác Boronkay György Gymnasium', description:'High School'},
        {date:'2019 - 2024', headline:'Hungarian University of Sport Science', description:'Sportmanagement Bsc'},
        {date:'2023 - 2024', headline:'Code Perfetto', description:'Junior Frontend Developer'},
    ];

    return(
        <section className='time-line' style={{backgroundImage:'url(/img/timeline.png)'}}>
            <div className='container'>
                <h1 className='title'>
                    TIMELINE
                </h1>
                <ul className='timeline-events'>
                    { events.map(event => 
                        <li>
                            <div className='event-image' style={{backgroundImage:'url(/img/timelineimage.jpg)'}}>
                            </div>
                            <div className='event'>
                                <div className='event-date' style={{backgroundImage:'url(/img/timelinedate.avif)'}}>
                                    <span> {event.date} </span>
                                </div>
                                <div className='event-content'>
                                    <h2 className='headline'>
                                        {event.headline}
                                    </h2>
                                    <p className='description'>
                                        {event.description}
                                    </p>
                                </div>
                            </div>
                        </li>
                    )}
                </ul>
            </div>
        </section>
    )
}

export default TimeLine;
