import './style.css';
import ReactStars from "react-rating-stars-component";


function Skills () {

    const skills = [
        {imgageUrl:'/img/htmllogo.jpg', name:'HTML', rating:5},
        {imgageUrl:'/img/csslogo.jpg', name:'CSS3', rating:4},
        {imgageUrl:'/img/jslogo.jpg', name:'Javascript', rating:3},
        {imgageUrl:'/img/reactlogo.jpg', name:'React.js', rating:3},
        {imgageUrl:'/img/uiuxlogo.jpg', name:'UI/UX', rating:4}

    ];


    return(
        <section className='skills' style={{backgroundImage:'url(/img/skillsbg.jpg)'}}> 
            <h2 className='headline'>
                SKILLS 
            </h2>
            <ul className='skill-list'>
                { skills.map((skill) => 
                <li className='skill-row'>
                    <img src={skill.imgageUrl}/>
                    <h2 className='skill-name'>
                        {skill.name}
                    </h2>
                    <div className='skill-rating-box'>
                    <ReactStars
                        count={skill.rating}
                        size={24}
                        activeColor="#ffd700"
                        color={"#ffd700"}
                        />
                    </div>
                </li>
                )}
            </ul>   
        </section>
    )

}

export default Skills;