import { useState } from 'react';
import './style.css';
import { Link } from 'react-router-dom';

function Navigation () {

    const navigationItems = [

        { id:'home', label: 'HOME', path: '/'},
        { id:'about-me', label: 'ABOUT ME', path: '/about-me'},
        { id:'products', label: 'PRODUCTS', path: '/products'},
        { id:'contact', label: 'CONTACT', path: '/contact'},
        { id:'home-work', label: 'CITIES', path: '/home-work'},
        { id:'articles', label: 'NEWS', path: '/articles'},
        { id:'competition', label: 'GAME', path:'/competition'},
        { id:'cart', label: 'CART', path: 'cart'}
    ];

    /* hozz létre egy javascript funckiót onNavigationToggle néven és 
        azt írja a console-be hogy "button clicked"
        a funkció akkor legyen meghívva ha a navigation toggler gombra kattint a felhasználó
    */

    const onNavigationToggle = () => {
        setIsOpened( isOpened ? false : true);
    }


    /*
        hozz létre egy állapottal rendelkező változót a useState segítségével
        a változó neve az legyen hogy isOpened 
        azt a funkciót ami beállítja az isOpened értékét pedig setIsOpened -nek hívjuk
        az isOpened alapértéke pedig false.
    */
    const [isOpened, setIsOpened] = useState(false);



    return (

        //<nav className='main-navigation' //style={{backgroundImage:'url(/img/navbg.jpg)'}}>
        <nav className='main-navigation'>
            <div className='main-navigation-img'>
                <img src='/img/navlogo.png' height={40} width={142}/>
            </div>
            <ul className='main-navigation-links' style={{display: isOpened ? 'flex' : 'none'}}>
                { navigationItems.map((navigationItem) => 
                    <li className='navigation-link-buttons'>
                        <Link to={navigationItem.path}>
                            <a>
                                {navigationItem.label}
                            </a>
                        </Link>
                    </li>
                )}
            </ul>
            <button className='mobile-toggler' onClick={() => onNavigationToggle()}>
                <span></span>
                <span></span>
                <span></span>
            </button>
        </nav>
        
    );
};

export default Navigation;