"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _lodashThrottle = require("lodash.throttle");

var _lodashThrottle2 = _interopRequireDefault(_lodashThrottle);

var _propTypes = require("prop-types");

var _propTypes2 = _interopRequireDefault(_propTypes);

var ScrollAnimation = (function (_Component) {
  _inherits(ScrollAnimation, _Component);

  function ScrollAnimation(props) {
    _classCallCheck(this, ScrollAnimation);

    _get(Object.getPrototypeOf(ScrollAnimation.prototype), "constructor", this).call(this, props);
    this.serverSide = typeof window === "undefined";
    this.listener = (0, _lodashThrottle2["default"])(this.handleScroll.bind(this), 50);
    this.visibility = {
      onScreen: false,
      inViewport: false
    };

    this.state = {
      classes: "animated",
      style: {
        animationDuration: this.props.duration + "s",
        opacity: this.props.initiallyVisible ? 1 : 0
      }
    };
  }

  _createClass(ScrollAnimation, [{
    key: "getElementTop",
    value: function getElementTop(elm) {
      var yPos = 0;
      while (elm && elm.offsetTop !== undefined && elm.clientTop !== undefined) {
        yPos += elm.offsetTop + elm.clientTop;
        elm = elm.offsetParent;
      }
      return yPos;
    }
  }, {
    key: "getScrollPos",
    value: function getScrollPos() {
      if (this.scrollableParent.pageYOffset !== undefined) {
        return this.scrollableParent.pageYOffset;
      }
      return this.scrollableParent.scrollTop;
    }
  }, {
    key: "getScrollableParentHeight",
    value: function getScrollableParentHeight() {
      if (this.scrollableParent.innerHeight !== undefined) {
        return this.scrollableParent.innerHeight;
      }
      return this.scrollableParent.clientHeight;
    }
  }, {
    key: "getViewportTop",
    value: function getViewportTop() {
      return this.getScrollPos() + this.props.offset;
    }
  }, {
    key: "getViewportBottom",
    value: function getViewportBottom() {
      return this.getScrollPos() + this.getScrollableParentHeight() - this.props.offset;
    }
  }, {
    key: "isInViewport",
    value: function isInViewport(y) {
      return y >= this.getViewportTop() && y <= this.getViewportBottom();
    }
  }, {
    key: "isAboveViewport",
    value: function isAboveViewport(y) {
      return y < this.getViewportTop();
    }
  }, {
    key: "isBelowViewport",
    value: function isBelowViewport(y) {
      return y > this.getViewportBottom();
    }
  }, {
    key: "inViewport",
    value: function inViewport(elementTop, elementBottom) {
      return this.isInViewport(elementTop) || this.isInViewport(elementBottom) || this.isAboveViewport(elementTop) && this.isBelowViewport(elementBottom);
    }
  }, {
    key: "onScreen",
    value: function onScreen(elementTop, elementBottom) {
      return !this.isAboveScreen(elementBottom) && !this.isBelowScreen(elementTop);
    }
  }, {
    key: "isAboveScreen",
    value: function isAboveScreen(y) {
      return y < this.getScrollPos();
    }
  }, {
    key: "isBelowScreen",
    value: function isBelowScreen(y) {
      return y > this.getScrollPos() + this.getScrollableParentHeight();
    }
  }, {
    key: "getVisibility",
    value: function getVisibility() {
      var elementTop = this.getElementTop(this.node) - this.getElementTop(this.scrollableParent);
      var elementBottom = elementTop + this.node.clientHeight;
      return {
        inViewport: this.inViewport(elementTop, elementBottom),
        onScreen: this.onScreen(elementTop, elementBottom)
      };
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      if (!this.serverSide) {
        var parentSelector = this.props.scrollableParentSelector;
        this.scrollableParent = parentSelector ? document.querySelector(parentSelector) : window;
        if (this.scrollableParent && this.scrollableParent.addEventListener) {
          this.scrollableParent.addEventListener("scroll", this.listener);
        } else {
          console.warn("Cannot find element by locator: " + this.props.scrollableParentSelector);
        }
        if (this.props.animatePreScroll) {
          this.handleScroll();
        }
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      clearTimeout(this.delayedAnimationTimeout);
      clearTimeout(this.callbackTimeout);
      this.listener.cancel();
      if (window && window.removeEventListener) {
        window.removeEventListener("scroll", this.listener);
      }
    }
  }, {
    key: "visibilityHasChanged",
    value: function visibilityHasChanged(previousVis, currentVis) {
      return previousVis.inViewport !== currentVis.inViewport || previousVis.onScreen !== currentVis.onScreen;
    }
  }, {
    key: "animate",
    value: function animate(animation, callback) {
      var _this = this;

      this.delayedAnimationTimeout = setTimeout(function () {
        _this.animating = true;
        _this.setState({
          classes: "animated " + animation,
          style: {
            animationDuration: _this.props.duration + "s"
          }
        });
        _this.callbackTimeout = setTimeout(callback, _this.props.duration * 1000);
      }, this.props.delay);
    }
  }, {
    key: "animateIn",
    value: function animateIn(callback) {
      var _this2 = this;

      this.animate(this.props.animateIn, function () {
        if (!_this2.props.animateOnce) {
          _this2.setState({
            style: {
              animationDuration: _this2.props.duration + "s",
              opacity: 1
            }
          });
          _this2.animating = false;
        }
        var vis = _this2.getVisibility();
        if (callback) {
          callback(vis);
        }
      });
    }
  }, {
    key: "animateOut",
    value: function animateOut(callback) {
      var _this3 = this;

      this.animate(this.props.animateOut, function () {
        _this3.setState({
          classes: "animated",
          style: {
            animationDuration: _this3.props.duration + "s",
            opacity: 0
          }
        });
        var vis = _this3.getVisibility();
        if (vis.inViewport && _this3.props.animateIn) {
          _this3.animateIn(_this3.props.afterAnimatedIn);
        } else {
          _this3.animating = false;
        }

        if (callback) {
          callback(vis);
        }
      });
    }
  }, {
    key: "handleScroll",
    value: function handleScroll() {
      if (!this.animating) {
        var currentVis = this.getVisibility();
        if (this.visibilityHasChanged(this.visibility, currentVis)) {
          clearTimeout(this.delayedAnimationTimeout);
          if (!currentVis.onScreen) {
            this.setState({
              classes: "animated",
              style: {
                animationDuration: this.props.duration + "s",
                opacity: this.props.initiallyVisible ? 1 : 0
              }
            });
          } else if (currentVis.inViewport && this.props.animateIn) {
            this.animateIn(this.props.afterAnimatedIn);
          } else if (currentVis.onScreen && this.visibility.inViewport && this.props.animateOut && this.state.style.opacity === 1) {
            this.animateOut(this.props.afterAnimatedOut);
          }
          this.visibility = currentVis;
        }
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this4 = this;

      var classes = this.props.className ? this.props.className + " " + this.state.classes : this.state.classes;
      return _react2["default"].createElement(
        "div",
        { ref: function (node) {
            _this4.node = node;
          }, className: classes, style: Object.assign({}, this.state.style, this.props.style) },
        this.props.children
      );
    }
  }]);

  return ScrollAnimation;
})(_react.Component);

exports["default"] = ScrollAnimation;

ScrollAnimation.defaultProps = {
  offset: 150,
  duration: 1,
  initiallyVisible: false,
  delay: 0,
  animateOnce: false,
  animatePreScroll: true
};

ScrollAnimation.propTypes = {
  animateIn: _propTypes2["default"].string,
  animateOut: _propTypes2["default"].string,
  offset: _propTypes2["default"].number,
  duration: _propTypes2["default"].number,
  delay: _propTypes2["default"].number,
  initiallyVisible: _propTypes2["default"].bool,
  animateOnce: _propTypes2["default"].bool,
  style: _propTypes2["default"].object,
  scrollableParentSelector: _propTypes2["default"].string,
  className: _propTypes2["default"].string,
  animatePreScroll: _propTypes2["default"].bool
};
module.exports = exports["default"];